import http.server
import socketserver
import numpy as np
import os
from findpsf import PsfFinder

PORT = 5000
STATIC_DIR = "browser"

han = PsfFinder()

class MyHandler(http.server.SimpleHTTPRequestHandler):
    def do_GET(self):
        if self.path == "/":
            self.path = "/index.html"
        self.path = STATIC_DIR + self.path 
        return super().do_GET()

    def retget(self):
        print("getting")
        response_data = han.get().tobytes()
        print("successfully got")
        self.send_response(200)
        self.send_header("Content-Type", "application/octet-stream")
        self.send_header("Content-Length", str(len(response_data)))
        self.end_headers()
        self.wfile.write(response_data)
    def do_POST(self):
        if self.path == "/ret":
            content_length = int(self.headers["Content-Length"])
            raw_data = self.rfile.read(content_length)
            data = np.frombuffer(raw_data, dtype=np.float32)
            han.update(data)
            self.retget()
            
        elif self.path == "/reset":
            print("Got reset command")
            han.reset()
            self.retget()
        else:
            self.send_response(404)
            self.end_headers()


with socketserver.TCPServer(("0.0.0.0", PORT), MyHandler) as httpd:
    print(f"Serving on port {PORT}")
    httpd.serve_forever()